﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Arrays
{
    class Examples6_10
    {
        private static void Show(string[] data)
        {
            foreach (string item in data)
            {
                Console.WriteLine(item);
            }
        }

        public static void LaboriousArrayInitialization()
        {
            // Listing 5-6
            var workingWeekDayNames = new string[5];
            workingWeekDayNames[0] = "poniedziałek";
            workingWeekDayNames[1] = "wtorek";
            workingWeekDayNames[2] = "środa";
            workingWeekDayNames[3] = "czwartek";
            workingWeekDayNames[4] = "piątek";

            Show(workingWeekDayNames);
        }

        public static void ArrayInitializer()
        {
            // Listing 5-7
            var workingWeekDayNames = new string[]
                { "poniedziałek", "wtorek", "środa", "czwartek", "piątek" };

            Show(workingWeekDayNames);
        }

        public static void ShorterArrayInitializer()
        {
            // Listing 5-8
            string[] workingWeekDayNames =
                { "Monday", "Tuesday", "Wednesday", "Thursday", "Friday" };

            Show(workingWeekDayNames);
        }

        public static void ArrayInitializerWithInference()
        {
            // Listing 5-9
            var workingWeekDayNames = new[]
                { "poniedziałek", "wtorek", "środa", "czwartek", "piątek" };

            Show(workingWeekDayNames);
        }

        public static void ArrayArgument()
        {
            // Listing 5-10
            SetHeaders(new[] { "poniedziałek", "wtorek", "środa", "czwartek", "piątek" });
        }

        private static void SetHeaders(string[] headers)
        {
            Show(headers);
        }
    }
}
